/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.errlog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import cz.insophy.inplan.util.Localizer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ErrorLogItem {
    private static final Pattern KEY_PATTERN = Pattern.compile("\\{(.*?)(,.*?)?}");
    private static ThreadLocal<StringBuilder> stringBuilders = ThreadLocal.withInitial(StringBuilder::new);
    private static ThreadLocal<MessageFormat> msgFormats = ThreadLocal.withInitial(() -> new MessageFormat(""));
    @Nonnull
    private final String messageKey;
    @Nullable
    private final Map<String, Object> data;
    private final int priority;

    ErrorLogItem(int priority, @Nonnull String messageKey, @Nullable Map<String, Object> data) {
        this.messageKey = Preconditions.checkNotNull(messageKey);
        this.data = data;
        this.priority = priority;
    }

    @Nonnull
    public Map<String, Object> getData() {
        if (this.data != null) {
            return Collections.unmodifiableMap(this.data);
        }
        return Collections.emptyMap();
    }

    @Nonnull
    public Level getLevel() {
        return this.priority > 0 ? Level.ERROR : Level.WARNING;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public String getMessageKey() {
        return this.messageKey;
    }

    @Nonnull
    public String getMessage() {
        String locFmt = Localizer.getStringIfExists(this.messageKey);
        return Strings.isNullOrEmpty(locFmt) ? this.getStandardFormat() : this.localizedMessage(locFmt);
    }

    @Nonnull
    private String localizedMessage(String locFmt) {
        if (this.data == null || this.data.isEmpty()) {
            return locFmt;
        }
        ImmutableList<String> keys = ImmutableList.copyOf(this.data.keySet());
        Matcher m3 = KEY_PATTERN.matcher(locFmt);
        StringBuilder sb = stringBuilders.get();
        sb.setLength(0);
        int pos = 0;
        while (m3.find()) {
            sb.append(locFmt, pos, m3.start());
            pos = m3.end();
            int idx = keys.indexOf(m3.group(1));
            if (idx < 0) continue;
            sb.append('{');
            sb.append(idx);
            if (m3.start(2) >= 0) {
                sb.append(locFmt, m3.start(2), m3.end(2));
            }
            sb.append('}');
        }
        sb.append(locFmt, pos, locFmt.length());
        MessageFormat msgFmt = msgFormats.get();
        msgFmt.setLocale(Localizer.getCurrentLocale());
        msgFmt.applyPattern(sb.toString());
        return msgFmt.format(this.data.values().toArray());
    }

    @Nonnull
    private String getStandardFormat() {
        StringBuilder sb = stringBuilders.get();
        sb.setLength(0);
        sb.append(this.messageKey);
        if (this.data != null && this.data.size() > 0) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                sb.append(' ');
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public String toString() {
        if (this.data == null || this.data.size() == 0) {
            return this.messageKey + ":" + this.priority;
        }
        return this.messageKey + ":" + this.priority + " " + this.data;
    }

    public static enum Level {
        ERROR,
        WARNING;

    }
}

